<?php
/**
 * Plugin Name: Lokalisa - entregas locales
 * Description: Integra WooCommerce con Lokalisa para cotizar envios y crear pedidos desde tu tienda.
 * Version: 0.1.0
 * Author: Lokalisa
 * Requires at least: 6.0
 * Requires PHP: 8.1
 * Text Domain: lokalisa-entregas-locales
 */

if (!defined('ABSPATH')) {
    exit;
}

if (!defined('LOKALISA_PLUGIN_PATH')) {
    define('LOKALISA_PLUGIN_PATH', plugin_dir_path(__FILE__));
}

if (!defined('LOKALISA_PLUGIN_URL')) {
    define('LOKALISA_PLUGIN_URL', plugin_dir_url(__FILE__));
}

require_once LOKALISA_PLUGIN_PATH . 'includes/class-lokalisa-plugin.php';

add_action('plugins_loaded', function () {
    if (!class_exists('WooCommerce')) {
        add_action('admin_notices', function () {
            echo '<div class="notice notice-error"><p>';
            echo esc_html__('Lokalisa requiere WooCommerce activo.', 'lokalisa-entregas-locales');
            echo '</p></div>';
        });
        return;
    }

    $plugin = new Lokalisa_Plugin();
    $plugin->init();
});
