<?php

if (!defined('ABSPATH')) {
    exit;
}

if (!class_exists('WC_Shipping_Method')) {
    return;
}

class WC_Shipping_Lokalisa extends WC_Shipping_Method
{
    private Lokalisa_Api_Client $api;
    public $settings;

    public function __construct($instance_id = 0)
    {
        $this->id = 'lokalisa';
        $this->method_title = 'Lokalisa';
        $this->method_description = 'Entrega local con Lokalisa.';
        $this->supports = ['shipping-zones', 'instance-settings'];
        $this->instance_id = absint($instance_id);

        $this->api = $GLOBALS['lokalisa_api_client'] ?? null;
        $this->settings = $GLOBALS['lokalisa_settings'] ?? null;

        $this->init();
    }

    public function init(): void
    {
        $this->enabled = 'yes';
        $this->title = (string) $this->settings->get_option('shipping_title', 'Lokalisa - entregas locales');
    }

    public function calculate_shipping($package = []): void
    {
        if (!$this->api || !$this->settings) {
            return;
        }

        $pickupId = (int) $this->settings->get_option('pickup_address_id', 0);
        if ($pickupId <= 0) {
            return;
        }

        $dropoffLat = WC()->session ? WC()->session->get('lokalisa_dropoff_lat') : null;
        $dropoffLng = WC()->session ? WC()->session->get('lokalisa_dropoff_lng') : null;

        if ($dropoffLat === null || $dropoffLng === null || $dropoffLat === '' || $dropoffLng === '') {
            return;
        }

        $quote = $this->api->quote([
            'pickup_address_id' => $pickupId,
            'dropoff_lat' => (float) $dropoffLat,
            'dropoff_lng' => (float) $dropoffLng,
        ]);

        if (!$quote || !isset($quote['fee'])) {
            return;
        }

        $rate = [
            'id' => $this->id,
            'label' => $this->title,
            'cost' => (float) $quote['fee'],
            'package' => $package,
        ];

        $this->add_rate($rate);
    }
}
