<?php

if (!defined('ABSPATH')) {
    exit;
}

class Lokalisa_Shipping_Method
{
    private Lokalisa_Api_Client $api;
    private Lokalisa_Settings $settings;

    public function __construct(Lokalisa_Api_Client $api, Lokalisa_Settings $settings)
    {
        $this->api = $api;
        $this->settings = $settings;
    }

    public function register(): void
    {
        $GLOBALS['lokalisa_api_client'] = $this->api;
        $GLOBALS['lokalisa_settings'] = $this->settings;

        add_action('woocommerce_shipping_init', [$this, 'register_method']);
        add_filter('woocommerce_shipping_methods', [$this, 'add_method']);
    }

    public function register_method(): void
    {
        if (!class_exists('WC_Shipping_Method')) {
            return;
        }

        if (!class_exists('WC_Shipping_Lokalisa')) {
            require_once LOKALISA_PLUGIN_PATH . 'includes/class-wc-shipping-lokalisa.php';
        }
    }

    public function add_method(array $methods): array
    {
        $methods['lokalisa'] = 'WC_Shipping_Lokalisa';
        return $methods;
    }
}
