<?php

if (!defined('ABSPATH')) {
    exit;
}

require_once LOKALISA_PLUGIN_PATH . 'includes/class-lokalisa-settings.php';
require_once LOKALISA_PLUGIN_PATH . 'includes/class-lokalisa-api-client.php';
require_once LOKALISA_PLUGIN_PATH . 'includes/class-lokalisa-shipping-method.php';
require_once LOKALISA_PLUGIN_PATH . 'includes/class-lokalisa-checkout.php';
require_once LOKALISA_PLUGIN_PATH . 'includes/class-lokalisa-ajax.php';
require_once LOKALISA_PLUGIN_PATH . 'includes/class-lokalisa-catalog-sync.php';

class Lokalisa_Plugin
{
    private Lokalisa_Settings $settings;
    private Lokalisa_Api_Client $api;
    private Lokalisa_Shipping_Method $shipping;
    private Lokalisa_Checkout $checkout;
    private Lokalisa_Ajax $ajax;
    private Lokalisa_Catalog_Sync $catalog_sync;

    public function init(): void
    {
        $this->settings = new Lokalisa_Settings();
        $this->api = new Lokalisa_Api_Client($this->settings);
        $this->shipping = new Lokalisa_Shipping_Method($this->api, $this->settings);
        $this->checkout = new Lokalisa_Checkout($this->api, $this->settings);
        $this->ajax = new Lokalisa_Ajax($this->settings);
        $this->catalog_sync = new Lokalisa_Catalog_Sync($this->api, $this->settings);

        $this->settings->register();
        $this->shipping->register();
        $this->checkout->register();
        $this->ajax->register();
        $this->catalog_sync->register();
    }
}
